
#ifdef MACVERSION 
#include <standard.h>
#endif

#ifdef WIN95VERSION 
#include "standard.h"
#endif

#include "quickdraw.h"
#include "popup.h"
#include "windowlayout.h"
#include "scrollbar.h"
#include "dialogs.h"
#include "shell.h"
#include "shellbuttons.h"
#include "op.h"
#include "opinternal.h"
#include "menueditor.h"
#include "menuinternal.h"



#define itemmargin 8

// 5.0a25 dmb: wire off Zoom button
#undef iconrectheight
#undef iconrectwidth
#define iconrectheight 0
#define iconrectwidth 0



static void mesetalloutlinerects (Rect r) {

	oppushoutline ((**menudata).menuoutline);
	
	insetrect (&r, 1, 1);
	
	opresize (r);
	
	#ifdef WIN95VERSION
		opupdatenow ();
	#endif

	oppopoutline ();
	} /*mesetalloutlinerects*/


boolean meresetwindowrects (hdlwindowinfo hw) {
	
	register hdlmenurecord hm = (hdlmenurecord) (**hw).hdata;
	short scrollbarwidth;
	short msgheight;
	Rect rcontent;
	Rect menurect;
	Rect r;
	
	if (outlinedata == nil)
		return (false);
	
	/*set up some values for all rect computations*/ {
	
		scrollbarwidth = getscrollbarwidth ();
		
		msgheight = popupheight; 
		}
	
	/*get contentrect and do info.growiconrect*/ {
		
		rcontent = (**hw).contentrect;
		
		shellcalcgrowiconrect (rcontent, hw);
		}
	
	/*inset contentrect uniformly*/ {
		
		insetrect (&rcontent, windowmargin, windowmargin);
		}
	
	/*do iconrect*/ {
	
		r = rcontent;
		
		r.bottom = r.top + iconrectheight;
		
		r.left = r.right - iconrectwidth;
		
	//	insetrect (&r, -4, 0); /*a little extra width for title*/
		
		if (hm != nil)
			(**hm).iconrect = r; 
		}
		
	/*do menurect*/ {
		
		menurect = rcontent;

		menurect.right -= iconrectwidth + windowmargin + scrollbarwidth;

		menurect.bottom -= msgheight + windowmargin;

		if (hm != nil)
			(**hm).menuoutlinerect = menurect;
		}
	
	/*do cmdkeypopuprect*/ {
		
		r = rcontent;
		
		r.top = r.bottom - msgheight;

		r.right = r.left + cmdkeypopupwidth;
		
		if (hm != nil)
			(**hm).cmdkeypopuprect = r; 
		}
	
	/*do messagerect*/ {
		
		r.left = r.right + popupbetweenwidth;
		
		r.right = menurect.right + scrollbarwidth;
		
		(**hw).messagerect = r; 
		}
		
	/*do vertscrollbar*/ {
		
		r = menurect; /*the space occupied by the grid of cells*/
		
		r.left = r.right; /*scrollbar is just to right of grid*/
		
		r.right = r.left + scrollbarwidth;
		
		setscrollbarrect ((**hw).vertscrollbar, r);
		
		//showscrollbar ((**hw).vertscrollbar);
		}
	
	return (true);
	} /*meresetwindowrects*/


void meresize (void) {
	
	Rect outlinerect;
	
	megetoutlinerect (&outlinerect); /*flow through code that adjusts the rect*/
	
	insetrect (&outlinerect, 1, 1);
	
	mesetalloutlinerects (outlinerect);
	} /*meresize*/


